load fisheriris
% Load Fisher's Iris dataset.

X = meas(:,3:4); 
% Select petal length and petal width as features.

Y = species; 
% Assign the species labels to Y.

tabulate(Y) 
% Display the frequency table for the species (probability table).

Mdl = fitcnb(X,Y,'ClassNames',{'setosa','versicolor','virginica'}); 
% Train a Naive Bayes classifier using petal length and width as features.

% The following lines are commented out but could be used to extract specific class parameters.
% setosaIndex = strcmp(Mdl.ClassNames,'setosa');
% estimates = Mdl.DistributionParameters{setosaIndex,1};

figure 
% Create a new figure window.

gscatter(X(:,1),X(:,2),Y); 
% Create a scatter plot of petal length vs. petal width, colored by species.

h = gca; 
% Get the current axis handle.

cxlim = h.XLim; 
% Store the current x-axis limits.

cylim = h.YLim; 
% Store the current y-axis limits.

hold on 
% Hold the current plot so that additional elements can be added.

Params = cell2mat(Mdl.DistributionParameters); 
% Get the Gaussian distribution parameters for the Naive Bayes model.

Mu = Params(2*(1:3)-1,1:2); 
% Extract the means (mu) for each class (setosa, versicolor, virginica).

Sigma = zeros(2,2,3); 
% Initialize a matrix for the covariance of each class.

for j = 1:3
    Sigma(:,:,j) = diag(Params(2*j,:)).^2; 
    % Create the diagonal covariance matrix for each class by squaring the standard deviations.

    xlim = Mu(j,1) + 4*[1 -1]*sqrt(Sigma(1,1,j)); 
    % Set the x-axis limits for the contour plot.

    ylim = Mu(j,2) + 4*[1 -1]*sqrt(Sigma(2,2,j)); 
    % Set the y-axis limits for the contour plot.

    ezcontour(@(x1,x2)mvnpdf([x1,x2],Mu(j,:),Sigma(:,:,j)),[xlim ylim]) 
    % Plot the contour of the multivariate normal distribution for each class.
end

h.XLim = cxlim; 
% Reset the x-axis limits to the original range.

h.YLim = cylim; 
% Reset the y-axis limits to the original range.

title('Naive Bayes Classifier -- Fisher''s Iris Data') 
% Set the title for the plot.

xlabel('Petal Length (cm)') 
% Set the x-axis label.

ylabel('Petal Width (cm)') 
% Set the y-axis label.

hold off 
% Release the hold on the current plot.
